<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.filehosting.api.IFileHosting.
 */

class FileHostingClient {

  protected $base;
  protected $sid;
  protected $domainUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param domainUid
   *
   */
  public function __construct($base, $sid , $domainUid) {
    $this->sid = $sid;
    $this->base = $base."/api/filehosting/{domainUid}";
    $this->domainUid = $domainUid;
    $this->base = str_replace("{domainUid}", urlencode($domainUid), $this->base);
  }


  /*
   * @param path
   * @param document
   * @return
   */
  public function store( $path ,  $document  ) {
    $postUri = "/{path}";
    $method = "PUT";

    $postUri = str_replace("{path}", urlencode($path), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $document;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param path
   * @return
   */
  public function list_( $path  ) {
    $postUri = "/_list";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "path" => $path);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param path
   * @return
   */
  public function delete_( $path  ) {
    $postUri = "/{path}";
    $method = "DELETE";

    $postUri = str_replace("{path}", urlencode($path), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getComplete( $uid  ) {
    $postUri = "/{uid}/_complete";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function getConfiguration() {
    $postUri = "/_config";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param query
   * @return
   */
  public function find( $query  ) {
    $postUri = "/_find";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "query" => $query);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param url
   * @return
   */
  public function unShare( $url  ) {
    $postUri = "/{url}/unshare";
    $method = "DELETE";

    $postUri = str_replace("{url}", urlencode($url), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param path
   * @return
   */
  public function get( $path  ) {
    $postUri = "/{path}/_content";
    $method = "GET";

    $postUri = str_replace("{path}", urlencode($path), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getSharedFile( $uid  ) {
    $postUri = "/{uid}/_public";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param path
   * @return
   */
  public function exists( $path  ) {
    $postUri = "/{path}/_exists";
    $method = "GET";

    $postUri = str_replace("{path}", urlencode($path), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param path
   * @param downloadLimit
   * @param expirationDate
   * @return
   */
  public function share( $path ,  $downloadLimit ,  $expirationDate  ) {
    $postUri = "/_share";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "path" => $path,      "downloadLimit" => $downloadLimit,      "expirationDate" => $expirationDate);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function info() {
    $postUri = "/_info";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
