/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.replica.service.internal;

import java.sql.SQLException;

import javax.sql.DataSource;

import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.persistence.MailboxRecordStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.persistence.IItemValueStore;
import net.bluemind.core.container.persistence.IWeightProvider;
import net.bluemind.core.container.service.internal.ContainerStoreService;
import net.bluemind.core.context.SecurityContext;

public class MailBoxRecordContainerStoreService extends ContainerStoreService<MailboxRecord> {

	public MailBoxRecordContainerStoreService(DataSource pool, SecurityContext securityContext, Container container,
			IItemValueStore<MailboxRecord> itemValueStore) {
		super(pool, securityContext, container, itemValueStore);
	}

	public MailBoxRecordContainerStoreService(DataSource ds, SecurityContext securityContext,
			Container recordsContainer, MailboxRecordStore recordStore, RecordsItemFlagProvider flagsProvider,
			IWeightSeedProvider<MailboxRecord> recordSeedProvider, IWeightProvider toWeight) {
		super(ds, securityContext, recordsContainer, recordStore, flagsProvider, recordSeedProvider, toWeight);
	}

	public ItemValue<MailboxRecord> getByImapUid(long imapUid) {
		Long itemId;
		try {
			itemId = ((MailboxRecordStore) itemValueStore).getByImapUid(imapUid);
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
		return null == itemId ? null : get(itemId, null);
	}

}
