<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MessageSearchResultMbox.
 */
class MessageSearchResultMbox  {

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type String
   */
  public $address;

  /*
   * @type String
   */
  public $routingType;

  /*
   * Constructor
   */
  public function __construct() {
    $this->displayName = "";
    $this->address = "";
    $this->routingType = "";
  }

  public function toMap() {
    $data = array(    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "address" => empty($this->address) ? null : $this->address,    
        "routingType" => empty($this->routingType) ? null : $this->routingType);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
