<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * AuthUser.
 */
class AuthUser  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type User
   */
  public $value;

  /*
   * @type Set
   */
  public $roles;

  /*
   * @type Map
   */
  public $rolesByOU;

  /*
   * @type Map
   */
  public $settings;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->domainUid = "";
    $this->displayName = "";
    $this->value =   new User();
    $this->roles = array();
    $this->rolesByOU = array();
    $this->settings = array();
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "value" => empty($this->value) ? null : $this->value,    
        "roles" => empty($this->roles) ? null : $this->roles,    
        "rolesByOU" => empty($this->rolesByOU) ? null : $this->rolesByOU,    
        "settings" => empty($this->settings) ? null : $this->settings);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
