<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardDeliveryAddressingAddress.
 */
class VCardDeliveryAddressingAddress extends VCardBasicAttribute {

  /*
   * @type String
   */
  public $postOfficeBox;

  /*
   * @type String
   */
  public $extentedAddress;

  /*
   * @type String
   */
  public $streetAddress;

  /*
   * @type String
   */
  public $locality;

  /*
   * @type String
   */
  public $region;

  /*
   * @type String
   */
  public $postalCode;

  /*
   * @type String
   */
  public $countryName;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->postOfficeBox = "";
    $this->extentedAddress = "";
    $this->streetAddress = "";
    $this->locality = "";
    $this->region = "";
    $this->postalCode = "";
    $this->countryName = "";
  }

  public function toMap() {
    $data = array(    
        "postOfficeBox" => empty($this->postOfficeBox) ? null : $this->postOfficeBox,    
        "extentedAddress" => empty($this->extentedAddress) ? null : $this->extentedAddress,    
        "streetAddress" => empty($this->streetAddress) ? null : $this->streetAddress,    
        "locality" => empty($this->locality) ? null : $this->locality,    
        "region" => empty($this->region) ? null : $this->region,    
        "postalCode" => empty($this->postalCode) ? null : $this->postalCode,    
        "countryName" => empty($this->countryName) ? null : $this->countryName);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
